-- new script file

function OnAfterSceneLoaded(self)
  CreateTriggerTargets(self)
  CreateTriggerSources(self)
end

function OnThink(self)
  if not self.initialized then
    self.initialized = true
    self.p0 = Citadels.GetPlayer(0)
    
    if not self.loaded then
      self.townsCounter = 0
      self.goalCompleted = false
    end
    
    self.twoTowns:LinkToTarget("reinfActive")
    self.threeTowns:LinkToTarget("questThirdTown")
  end
  
  if self.townsCounter == 2 and not self.goalCompleted then
    self.twoTowns:TriggerAllTargets()
    self.p0:WinQuest('D9G_GOAL_2')
    MarkQuest(self)
    self.goalCompleted = true
  end
  
  if self.townsCounter == 3 then
    self.p0:WinQuest('D9_THIRD_TOWN')
    self.threeTowns:TriggerAllTargets()
    self.townsCounter = 0
  end 
end

function MarkQuest(self)
  g3PosX = Game:GetEntity("mainBase"):GetPosition().x
  g3PosY = Game:GetEntity("mainBase"):GetPosition().y
  qPosX = Game:GetEntity("largeTown"):GetPosition().x
  qPosY = Game:GetEntity("largeTown"):GetPosition().y
  
  self.p0:AddQuest('D9G_GOAL_3','main')
  self.p0:SetQuestPosition('D9G_GOAL_3', g3PosX, g3PosY)
  
  self.p0:AddQuest('D09_THIRD_TOWN', 'side')
  self.p0:SetQuestPosition('D09_THIRD_TOWN', qPosX, qPosY)
end


function OnTrigger(self, source, target)
  if target == "mTown" then
    self.townsCounter = self.townsCounter + 1 
  elseif target == "sTown" then
    self.townsCounter = self.townsCounter + 1
  elseif target == "lTown" then
    self.townsCounter = self.townsCounter + 1
  end
end

function OnSerialize(self, ar)
  if (ar:IsLoading()) and Citadels.GetLoadGameRunning() then
    CreateTriggerSources(self)
    self.loaded = true
    self.townsCounter = ar:Read()
    self.goalCompleted = ar:Read()
  elseif (ar:IsSaving()) then
    ar:Write(self.townsCounter)
    ar:Write(self.goalCompleted)
  end
end

function CreateTriggerTargets(self)
  self:AddTriggerTarget("mTown")
  self:AddTriggerTarget("sTown")
  self:AddTriggerTarget("lTown")
end

function CreateTriggerSources(self)
  self:AddTriggerSource("twoTowns")
  self:AddTriggerSource("threeTowns")
end
